import numpy as np
import os
import argparse

folders = ['Trained_Models_Linear', 'No_Coeff_Trained_Models_Linear']

for folder in folders:
    tasks = os.listdir(folder)
    for task in tasks:
        task_split = task.split('_')
        seeds = os.listdir(f'{folder}/{task}')
        for seed in seeds:
            trials = os.listdir(f'{folder}/{task}/{seed}')
            for trial in trials:
                name = f'{folder}/{task}/{seed}/{trial}'
                if not os.path.exists(f'{name}/log.txt'):
                    print(name)
                    continue

                with open(f'{name}/log.txt') as f:
                    data = f.read().split('\n')[:-1]
                    params = int(data[0].split(':')[-1])
                    if '100000' not in data[-1]:
                        print(name)